//
//  HelperFunctions.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

public var playedInstrumentNotes: [Instrument.Kind : [UInt8]] = [:]

public func playInstrument(_ kind: Instrument.Kind, note: MIDINoteProtocol, volume: Double = 75) {
    let velocity = UInt8(abs(volume/100) * 127)
    playInstrument(kind, note: note.midiCode, volume: velocity)
    
    if playedInstrumentNotes[kind] == nil {
        playedInstrumentNotes[kind] = [note.midiCode]
    } else {
        playedInstrumentNotes[kind]! += [note.midiCode]
    }
}
